	function alfaQ = QUANTIZE_ALFA(alfa, Wceff)
	
	% 	Quantize the adaptor coefficients to Wceff bit so that the sum 
	%	is equal to 2.
	% 	Note that we use integers/2^Wceff for the quantized coefficients.
	
	% 	Toolbox for DIGITAL FILTERS USING MATLAB
	
	% 	Author: 		Lars Wanhammar, 2019-03-21
	% 	Modified by:		 
	% 	Copyright:		by authors - not released for commercial use
	% 	Version: 		1	
	% 	Known bugs:		
	% 	Report bugs to:	Wanhammar@gamil.com
	
	W = 2^Wceff;
	alfaQ = round(alfa*W);
	for n = 1:length(alfaQ(:,1))
		if n == 1
			alfaQ(1,2) = alfaQ(1,1);
			alfaQ(1,3) = 2*W - alfaQ(1,1) - alfaQ(1,2);
			%			alfaQ(1,4) = 0; 
		else
			alfaQ(n,4) = 2*W - alfaQ(n,1) -  alfaQ(n,2) - alfaQ(n,3);	
		end	
	end			
	alfaQ(1,4) = 1; 	% Set to 1 to avoide calling mincost(0 
		
